=== Web Accessibility with Max Access ===
Contributors: onlineada
Plugin Name: Web Accessibility with Max Access
Plugin URI: https://onlineada.com/
Tags: accessibility, accessibility compliance, wcag, WordPress accessibility, accessibility toolbar, web accessibility
Author URI: https://onlineada.com/
Author: Ability, Inc
Tested up to: 6.8
Requires at least: 4.6
Stable tag: 2.0.9
Version: 2.0.9
Requires PHP: ^5.6
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html

The ultimate web accessibility plugin. Leverages AI to scan your site, fix website code, and improve SEO. Includes the web accessibility toolbar.

== Description ==

Take your web accessibility to the next level with the Max Access WordPress Plugin, the ultimate tool for boosting your website’s accessibility. Developed by the web accessibility experts at Ability, Inc., this plugin seamlessly integrates with your WordPress site to provide comprehensive accessibility solutions, helping you meet the Web Content Accessibility Guidelines (WCAG) and other international standards.

Max Access is free forever and does not require a credit card to use. There are paid pro and AI-driven features available if you want them.

**Features That Make a Difference**

1. **Real-Time Issue Detection and Fixes**
    Max Access identifies and corrects web accessibility issues in real-time. This feature allows you to boost compliance as you create and update content, saving you time and effort.

2. **Customizable Accessibility Toolbar**
    Enhance your site's user experience with a customizable accessibility toolbar. Visitors can adjust settings to suit their needs, such as text size, contrast, and more, ensuring a personalized browsing experience.

3. **Text to Speech**
    Max Access features advanced text-to-speech capabilities that convert written content into natural-sounding audio in real-time. This feature supports multiple languages and voice options, ensuring that all users, including those with visual impairments or reading difficulties, can access and understand your content.

4. **Extended Remediation Reports**
    Receive detailed compliance reports that outline your site's accessibility status. These reports are invaluable for maximizing your accessibility beyond automated remediation.

5. **AI-Driven Alt-Tag & ARIA Label Manager**
    Max Access leverages AI to automatically generate accurate alt tags for images and ARIA labels for interactive elements but gives you full access to oversee, manage, and update them as you see fit or to maximize your SEO.

6. **Regular Updates and Support**
    Stay ahead of the curve with regular updates that ensure your site remains compliant with the latest accessibility standards. Our dedicated support team is always ready to assist with any issues or questions.

7. **User-Friendly Interface**
    Designed for ease of use, the plugin features an intuitive interface that makes navigating accessibility features simple, even for those with limited technical expertise.

**Benefits That Drive Results**

1. **Boosts Your Website's Reach and Engagement**
   By making your website more accessible, you expand your audience, increase user engagement, and improve brand perception among all visitors.

2. **Enhances SEO Performance**
   Accessible websites often rank higher in search engine results. Max Access WordPress helps you optimize your site for both accessibility and SEO, driving more organic traffic.

3. **Mitigates Legal Risks**
   Lack of web accessibility can lead to costly lawsuits. Max Access helps you stay compliant with WCAG and other accessibility requirements, significantly.

4. **Increases Conversion Rates**
   Accessible websites provide a better user experience, leading to higher conversion rates. Ensure potential customers can navigate and interact with your site easily.

**Why Choose Web Accessibility with Max Access WordPress?**
Max Access is built by Ability, Inc., a leader in web accessibility solutions. Our expertise and dedication to inclusivity have driven the development of the Max Access web accessibility plugin.

== Installation ==

== Screenshots ==

1. Front end view of Toolbar collapsed
2. Front end view of Toolbar expanded

== Upgrade Notice ==

== Changelog ==
- [ 2.0.2 ] - 7/17/2024
- Patched bug where plugin domain check returned errors with domains starting with 'www.'
- Addressed some issues with enqueued scripts which occasionally caused php warnings to appear
- Fixed bug that adds '#' to end of url

- [ 2.0.1 ] - 4/26/2024
- Patched bug where plugin CSS occasionally conflicted with WordPress Admin Panel
- Improved formatting & styling on plugin admin panel
- Tested up to WordPress 6.5.2

- [2.0.0 ] - 4/3/2024
* Upgraded the Accessibility Toolbar to our new product Max Access.
* Tested up to WordPress 6.3 and PHP 8.2
* Upgraded all customers who previously paid for a pro license to Max Access Standard, which will be reflected on your dashboard.onlineada.com account. You're now receiving a far superior service for the same price.

- [ 1.40.2 ] - 11/09/2022
* Fixed version number on plugin

- [ 1.40.1] - 11/09/2022
* Tested up to wordpress 6.1
* Added support for up to PHP 8.1

- [ 1.3.1 ] - 01/26/2021

* Tested working on version 5.6 of WordPress

- [ 1.3.0 ] - 02/25/2020

* Fixed positioning and performance issues.

- [ 1.2.8 ] - 10/28/2019

* Added new features for pro version including hiding the account settings gear and positioning the toolbar on either the left or right hand side of the page.

- [ 1.2.7 ] - 09/23/2019

* Fixed issue with regex patterns not working within Firefox and IE.

- [ 1.2.6 ] - 09/18/2019

* Fixed compatibility issues with phone link script replacing visual composer auto generated class names.

- [ 1.2.5 ] - 09/10/2019

* Fixed compatibility issues with Firefox and IE.

- [ 1.2.2 ] - 05/20/2019

* Updates to the usibility of the text to speech feature for pro users.

- [ 1.2.1 ] - 05/20/2019

* Updated the accessibility menu display conditions.

- [ 1.2.0 ] - 05/17/2019

* Added new options for accessibility toolbar pro.

- [ 1.1.10 ] - 05/16/2019

* Fixed issue with special function script that was throwing errors when coming across empty anchor tags.

- [ 1.1.8 ] - 05/15/2019

* Added new link/button outline as a pro feature.
* Added a new menu page "Element Controls" that show the special toolbar classes that add control over how the toolbar handles elements on your site.

- [ 1.1.7 ] - 05/14/2019

* Updates to the admin dashboard for the toolbar.

- [ 1.1.6 ] - 05/14/2019

* The ada-img-hide class now accounts for svgs.

- [ 1.1.5 ] - 05/14/2019

* Updated contrast scripts to account for all body p tags that were previously being overlooked.

- [ 1.1.4 ] - 05/14/2019

* Adjusted plugin name and added optimization to toolbar front end scripts.

- [ 1.1.3 ] - 05/13/2019

* Added functionality for hiding all background images.

== Frequently Asked Questions ==


