<?php // $file = /var/www/domains/forthrightwinery.com/html/wp-content/themes/yootheme/packages/theme-wordpress/config/customizer.json

return [
  'cookie' => $config->get('theme.cookie'), 
  'sections' => [
    'layout' => [
      'help' => [[
          'title' => 'Using the Sidebar', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=nZm-qEyGaP4&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:55', 
          'documentation' => 'support/yootheme-pro/wordpress/customizer#save,-cancel-and-close', 
          'support' => 'support/search?tags=125&q=customizer%20save'
        ], [
          'title' => 'Using the Contextual Help', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=BGgRZvlJVXI&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:38', 
          'documentation' => 'support/yootheme-pro/wordpress/customizer#contextual-help', 
          'support' => 'support/search?tags=125&q=contextual%20help'
        ], [
          'title' => 'Using the Device Preview Buttons', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=hGErRJcl9ts&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:42', 
          'documentation' => 'support/yootheme-pro/wordpress/customizer#device-preview-buttons', 
          'support' => 'support/search?tags=125&q=customizer%20device%20preview'
        ], [
          'title' => 'Hide and Adjust the Sidebar', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=xzc6tuF500w&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:35', 
          'documentation' => 'support/yootheme-pro/wordpress/customizer#hide-and-adjust-sidebar', 
          'support' => 'support/search?tags=125&q=customizer%20hide%20sidebar'
        ]]
    ], 
    'styler' => [
      'help' => [
        'WooCommerce' => [[
            'title' => 'Using the WooCommerce Style Customizer', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=U8z7SDFIfBw&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '3:10', 
            'documentation' => 'support/yootheme-pro/wordpress/woocommerce#style-customizer', 
            'support' => 'support/search?tags=125&q=woocommerce%20style'
          ]]
      ]
    ], 
    'builder-pages' => [
      'help' => [
        'Pages' => [[
            'title' => 'Managing Pages', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=_v2hxqY71Jc&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:27', 
            'documentation' => 'support/yootheme-pro/wordpress/pages', 
            'support' => 'support/search?tags=125&q=pages%20builder'
          ], [
            'title' => 'Adding a New Page', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=vaHK3xRJD9M&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:18', 
            'documentation' => 'support/yootheme-pro/wordpress/pages#add-a-new-page', 
            'support' => 'support/search?tags=125&q=page%20builder'
          ], [
            'title' => 'Creating Individual Post Layouts', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=Pw42Niyzk7s&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '2:22', 
            'documentation' => 'support/yootheme-pro/wordpress/pages#individual-post-layout', 
            'support' => 'support/search?tags=125&q=post%20builder'
          ]], 
        'Customizer' => [[
            'title' => 'Using the Sidebar', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=nZm-qEyGaP4&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:55', 
            'documentation' => 'support/yootheme-pro/wordpress/customizer#save,-cancel-and-close', 
            'support' => 'support/search?tags=125&q=customizer%20save'
          ], [
            'title' => 'Using the Contextual Help', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=BGgRZvlJVXI&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:38', 
            'documentation' => 'support/yootheme-pro/wordpress/customizer#contextual-help', 
            'support' => 'support/search?tags=125&q=contextual%20help'
          ], [
            'title' => 'Using the Device Preview Buttons', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=hGErRJcl9ts&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:42', 
            'documentation' => 'support/yootheme-pro/wordpress/customizer#device-preview-buttons', 
            'support' => 'support/search?tags=125&q=customizer%20device%20preview'
          ], [
            'title' => 'Hide and Adjust the Sidebar', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=xzc6tuF500w&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:35', 
            'documentation' => 'support/yootheme-pro/wordpress/customizer#hide-and-adjust-sidebar', 
            'support' => 'support/search?tags=125&q=customizer%20hide%%20sidebar'
          ]]
      ]
    ], 
    'builder-templates' => [
      'help' => [
        'Templates' => [[
            'title' => 'Managing Templates', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=B1JjjHBN9IQ&list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:48', 
            'documentation' => 'support/yootheme-pro/wordpress/templates', 
            'support' => 'support/search?tags=125&q=templates'
          ], [
            'title' => 'Assigning Templates to Pages', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=F9RgSgnx1nQ&list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '4:43', 
            'documentation' => 'support/yootheme-pro/wordpress/templates#page-assignment', 
            'support' => 'support/search?tags=125&q=template%20page%20assignment'
          ], [
            'title' => 'Setting the Template Loading Priority', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=w1TFj_RJWbE&list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:41', 
            'documentation' => 'support/yootheme-pro/wordpress/templates#loading-priority', 
            'support' => 'support/search?tags=125&q=template%20priority'
          ], [
            'title' => 'Setting the Template Status', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=b5NS5I9IEMw&list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:02', 
            'documentation' => 'support/yootheme-pro/wordpress/templates#status', 
            'support' => 'support/search?tags=125&q=template%20status'
          ]]
      ]
    ], 
    'settings' => [
      'help' => [[
          'title' => 'Using the Sidebar', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=nZm-qEyGaP4&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:55', 
          'documentation' => 'support/yootheme-pro/wordpress/customizer#save,-cancel-and-close', 
          'support' => 'support/search?tags=125&q=customizer%20save'
        ], [
          'title' => 'Using the Contextual Help', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=BGgRZvlJVXI&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:38', 
          'documentation' => 'support/yootheme-pro/wordpress/customizer#contextual-help', 
          'support' => 'support/search?tags=125&q=contextual%20help'
        ], [
          'title' => 'Using the Device Preview Buttons', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=hGErRJcl9ts&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:42', 
          'documentation' => 'support/yootheme-pro/wordpress/customizer#device-preview-buttons', 
          'support' => 'support/search?tags=125&q=customizer%20device%20preview'
        ], [
          'title' => 'Hide and Adjust the Sidebar', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=xzc6tuF500w&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:35', 
          'documentation' => 'support/yootheme-pro/wordpress/customizer#hide-and-adjust-sidebar', 
          'support' => 'support/search?tags=125&q=customizer%20hide%%20sidebar'
        ]]
    ]
  ], 
  'panels' => [
    'site' => [
      'help' => [
        'Site' => [[
            'title' => 'Adding the Logo', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=UItCS_pSAXA&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '2:25', 
            'documentation' => 'support/yootheme-pro/wordpress/site-and-logo#logo', 
            'support' => 'support/search?tags=125&q=logo'
          ], [
            'title' => 'Setting the Page Layout', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=ScYJ-bVJ94s&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:35', 
            'documentation' => 'support/yootheme-pro/wordpress/site-and-logo#layout', 
            'support' => 'support/search?tags=125&q=site%20layout'
          ], [
            'title' => 'Using the Toolbar', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=uigKZP3xu-4&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:58', 
            'documentation' => 'support/yootheme-pro/wordpress/site-and-logo#toolbar', 
            'support' => 'support/search?tags=125&q=toolbar'
          ], [
            'title' => 'Displaying the Breadcrumbs', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=Eiw_1rf3hHE&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:04', 
            'documentation' => 'support/yootheme-pro/wordpress/site-and-logo#breadcrumbs', 
            'support' => 'support/search?tags=125&q=breadcrumbs'
          ], [
            'title' => 'Setting the Main Section Height', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=CDeYl5TIfZQ&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:46', 
            'documentation' => 'support/yootheme-pro/wordpress/site-and-logo#main-section', 
            'support' => 'support/search?tags=125&q=main%20section'
          ]], 
        'Image Field' => [[
            'title' => 'Using Images', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=tX5eOfIQF0U&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '4:29', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#images', 
            'support' => 'support/search?tags=125&q=image%20field'
          ], [
            'title' => 'Using the Media Manager', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=ELnpkZcQEBE&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:26', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#media-manager', 
            'support' => 'support/search?tags=125&q=media%20manager'
          ], [
            'title' => 'Using the Unsplash Library', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=0cgrc7HORj0&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:49', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#unsplash-library', 
            'support' => 'support/search?tags=125&q=unsplash'
          ]]
      ]
    ], 
    'header' => [
      'help' => [[
          'title' => 'Setting the Header Layout', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=s8kdtEH55dg&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '3:51', 
          'documentation' => 'support/yootheme-pro/wordpress/header-and-navbar#header-layout', 
          'support' => 'support/search?tags=125&q=header%20layout'
        ], [
          'title' => 'Setting the Navbar', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=oQ1ja29Tl1Y&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '1:19', 
          'documentation' => 'support/yootheme-pro/wordpress/header-and-navbar#navbar', 
          'support' => 'support/search?tags=125&q=navbar'
        ], [
          'title' => 'Using the Dropdown Menu', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=98MdMe3CVFM&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '1:12', 
          'documentation' => 'support/yootheme-pro/wordpress/header-and-navbar#dropdown', 
          'support' => 'support/search?tags=125&q=navbar%20dropdown'
        ], [
          'title' => 'Setting the Dialog Layout', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=ePV2Yjtac7o&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '5:07', 
          'documentation' => 'support/yootheme-pro/wordpress/header-and-navbar#dialog-layout', 
          'support' => 'support/search?tags=125&q=dialog%20layout'
        ], [
          'title' => 'Adding the Search', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=L6e1KmgTcjU&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '1:06', 
          'documentation' => 'support/yootheme-pro/wordpress/header-and-navbar#search', 
          'support' => 'support/search?tags=125&q=header%20search'
        ], [
          'title' => 'Adding the Social Icons', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=PW8TitfsOAM&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '1:55', 
          'documentation' => 'support/yootheme-pro/wordpress/header-and-navbar#social-icons', 
          'support' => 'support/search?tags=125&q=header%20social'
        ]]
    ], 
    'mobile' => [
      'help' => [[
          'title' => 'Displaying the Mobile Header', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=IpZphdiSYbs&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:57', 
          'documentation' => 'support/yootheme-pro/wordpress/mobile-header#visibility', 
          'support' => 'support/search?tags=125&q=mobile%20header%20visibility'
        ], [
          'title' => 'Setting the Mobile Header Layout', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=_A7f-HFYp_g&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '1:43', 
          'documentation' => 'support/yootheme-pro/wordpress/mobile-header#header-layout', 
          'support' => 'support/search?tags=125&q=mobile%20header%20layout'
        ], [
          'title' => 'Setting the Mobile Navbar', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=4prD75e1X2c&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:58', 
          'documentation' => 'support/yootheme-pro/wordpress/mobile-header#navbar', 
          'support' => 'support/search?tags=125&q=mobile%20header%20navbar'
        ], [
          'title' => 'Setting the Mobile Dialog Layout', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=RGVxOdlpDIg&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '4:25', 
          'documentation' => 'support/yootheme-pro/wordpress/mobile-header#dialog-layout', 
          'support' => 'support/search?tags=125&q=mobile%20dialog%20layout'
        ], [
          'title' => 'Setting the Mobile Search', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=gF_kx6Lq7sY&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:59', 
          'documentation' => 'support/yootheme-pro/wordpress/mobile-header#search', 
          'support' => 'support/search?tags=125&q=mobile%20search'
        ], [
          'title' => 'Adding the Social Icons', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=t8ftHK4UT_c&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '1:27', 
          'documentation' => 'support/yootheme-pro/wordpress/mobile-header#social-icons', 
          'support' => 'support/search?tags=125&q=mobile%20social%20icons'
        ]]
    ], 
    'top' => [
      'help' => [
        'Top and Bottom' => [[
            'title' => 'Setting the Top and Bottom Areas', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=fqIxFSXiulI&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:41', 
            'documentation' => 'support/yootheme-pro/wordpress/top-bottom-and-sidebar#top-and-bottom', 
            'support' => 'support/search?tags=125&q=top%20bottom%20position%20settings'
          ]], 
        'Image Field' => [[
            'title' => 'Using Images', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=tX5eOfIQF0U&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '4:29', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#images', 
            'support' => 'support/search?tags=125&q=image%20field'
          ], [
            'title' => 'Using the Media Manager', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=ELnpkZcQEBE&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:26', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#media-manager', 
            'support' => 'support/search?tags=125&q=media%20manager'
          ], [
            'title' => 'Using the Unsplash Library', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=0cgrc7HORj0&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:49', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#unsplash-library', 
            'support' => 'support/search?tags=125&q=unsplash'
          ]], 
        'Builder' => [[
            'title' => 'The Area Element', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=wpV6Ll_wT_Y&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:58', 
            'documentation' => 'support/yootheme-pro/wordpress/system-elements#area-element', 
            'support' => 'support/search?tags=125&q=area%20element'
          ], [
            'title' => 'Collapsing Layouts', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=3Vqe94SZeHM&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:42', 
            'documentation' => 'support/yootheme-pro/wordpress/collapsing-layouts', 
            'support' => 'support/search?tags=125&q=collapsing'
          ]]
      ]
    ], 
    'sidebar' => [
      'help' => [
        'Sidebar' => [[
            'title' => 'Setting the Sidebar Area', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=g1exLdgmPd8&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:32', 
            'documentation' => 'support/yootheme-pro/wordpress/top-bottom-and-sidebar#sidebar', 
            'support' => 'support/search?tags=125&q=sidebar%20position%20settings'
          ]], 
        'Builder' => [[
            'title' => 'The Area Element', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=wpV6Ll_wT_Y&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:58', 
            'documentation' => 'support/yootheme-pro/wordpress/system-elements#area-element', 
            'support' => 'support/search?tags=125&q=area%20element'
          ], [
            'title' => 'Collapsing Layouts', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=3Vqe94SZeHM&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:42', 
            'documentation' => 'support/yootheme-pro/wordpress/collapsing-layouts', 
            'support' => 'support/search?tags=125&q=collapsing'
          ]]
      ]
    ], 
    'bottom' => [
      'help' => [
        'Top and Bottom' => [[
            'title' => 'Setting the Top and Bottom Areas', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=fqIxFSXiulI&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:41', 
            'documentation' => 'support/yootheme-pro/wordpress/top-bottom-and-sidebar#top-and-bottom', 
            'support' => 'support/search?tags=125&q=top%20bottom%20position%20settings'
          ]], 
        'Image Field' => [[
            'title' => 'Using Images', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=tX5eOfIQF0U&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '4:29', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#images', 
            'support' => 'support/search?tags=125&q=image%20field'
          ], [
            'title' => 'Using the Media Manager', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=ELnpkZcQEBE&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:26', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#media-manager', 
            'support' => 'support/search?tags=125&q=media%20manager'
          ], [
            'title' => 'Using the Unsplash Library', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=0cgrc7HORj0&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:49', 
            'documentation' => 'support/yootheme-pro/wordpress/files-and-images#unsplash-library', 
            'support' => 'support/search?tags=125&q=unsplash'
          ]], 
        'Builder' => [[
            'title' => 'The Area Element', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=wpV6Ll_wT_Y&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:58', 
            'documentation' => 'support/yootheme-pro/wordpress/system-elements#area-element', 
            'support' => 'support/search?tags=125&q=area%20element'
          ], [
            'title' => 'Collapsing Layouts', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=3Vqe94SZeHM&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:42', 
            'documentation' => 'support/yootheme-pro/wordpress/collapsing-layouts', 
            'support' => 'support/search?tags=125&q=collapsing'
          ]]
      ]
    ], 
    'footer-builder' => [
      'help' => [
        'Footer Builder' => [[
            'title' => 'Using the Footer Builder', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=WXfOV_ipCsI&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:58', 
            'documentation' => 'support/yootheme-pro/wordpress/footer-builder', 
            'support' => 'support/search?tags=125&q=footer%20builder'
          ]], 
        'Builder Widget' => [[
            'title' => 'Using the Builder Widget', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=JMpEPdC9VN4&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:22', 
            'documentation' => 'support/yootheme-pro/wordpress/widgets-and-modules#builder-widget', 
            'support' => 'support/search?tags=125&q=builder%20widget'
          ], [
            'title' => 'Creating Advanced Widget Layouts', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=_0vGzg_lmsg&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '3:55', 
            'documentation' => 'support/yootheme-pro/wordpress/widgets-and-modules#advanced-layouts', 
            'support' => 'support/search?tags=125&q=builder%20widget'
          ]]
      ]
    ], 
    'advanced' => [
      'fields' => [
        'disable_wpautop' => [
          'label' => 'Filter', 
          'type' => 'checkbox', 
          'text' => 'Disable wpautop'
        ], 
        'disable_emojis' => [
          'description' => 'Disable the <a href="https://developer.wordpress.org/reference/functions/wpautop/" target="_blank">wpautop</a> filter for the_content and the_excerpt and disable conversion of Emoji characters to images.', 
          'type' => 'checkbox', 
          'text' => 'Disable Emojis'
        ], 
        'jquery' => [
          'label' => 'System Assets', 
          'description' => 'Load jQuery to write custom code based on the jQuery JavaScript library.', 
          'text' => 'Load jQuery', 
          'type' => 'checkbox'
        ], 
        'search_filter' => [
          'label' => 'Search Filter', 
          'description' => 'Only search the selected post types.', 
          'type' => 'select', 
          'options' => [[
              'evaluate' => 'yootheme.builder.postTypes'
            ]], 
          'attrs' => [
            'multiple' => true
          ]
        ], 
        'search_page' => [
          'label' => 'Search Redirect', 
          'type' => 'select', 
          'description' => 'Only post types with an archive can be redirected to the archive page.', 
          'options' => [
            'Search Page' => '', 
            'Post Type Archive page' => 'archive'
          ], 
          'enable' => 'search_filter.length === 1 && yootheme.builder.postTypesWithArchive.includes(search_filter[0])'
        ]
      ]
    ], 
    'api-key' => [
      'fields' => [
        'minimum_stability' => [
          'label' => 'Minimum Stability', 
          'description' => 'The minimum stability of the theme updates. Stable is recommended for production websites, Beta is only for testing new features and reporting issues.', 
          'type' => 'select', 
          'options' => [
            'Stable' => 'stable', 
            'Beta' => 'beta'
          ]
        ]
      ], 
      'help' => [[
          'title' => 'Updating YOOtheme Pro', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=hFTEfAWyzXg&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '1:23', 
          'documentation' => 'support/yootheme-pro/wordpress/updating', 
          'support' => 'support/search?tags=125&q=update%20yootheme%20pro'
        ], [
          'title' => 'Setting the Minimum Stability', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=fys-pASftVU&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:43', 
          'documentation' => 'support/yootheme-pro/wordpress/updating#minimum-stability', 
          'support' => 'support/search?tags=125&q=minimum%20stability'
        ]]
    ], 
    'about' => [
      'help' => [[
          'title' => 'Opening the Changelog', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=9ltKuvNHV5U&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '1:05', 
          'documentation' => 'support/yootheme-pro/wordpress/updating#changelog', 
          'support' => 'support/search?tags=125&q=changelog'
        ]]
    ], 
    'system-post' => [
      'title' => 'Post', 
      'width' => 400, 
      'fields' => [
        'post.width' => [
          'label' => 'Width', 
          'description' => 'Set the post width. The image and content can\'t expand beyond this width.', 
          'type' => 'select', 
          'options' => [
            'X-Small' => 'xsmall', 
            'Small' => 'small', 
            'Default' => 'default', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'Expand' => 'expand', 
            'None' => ''
          ]
        ], 
        'post.padding' => [
          'label' => 'Padding', 
          'description' => 'Set the vertical padding.', 
          'type' => 'select', 
          'options' => [
            'Default' => '', 
            'X-Small' => 'xsmall', 
            'Small' => 'small', 
            'Large' => 'large', 
            'X-Large' => 'xlarge'
          ]
        ], 
        'post.padding_remove' => [
          'type' => 'checkbox', 
          'text' => 'Remove top padding'
        ], 
        'post.content_width' => [
          'label' => 'Content Width', 
          'description' => 'Set an optional content width which doesn\'t affect the image.', 
          'type' => 'select', 
          'options' => [
            'Auto' => '', 
            'X-Small' => 'xsmall', 
            'Small' => 'small'
          ], 
          'enable' => 'post.width != \'xsmall\''
        ], 
        'post.image_align' => [
          'label' => 'Image Alignment', 
          'description' => 'Align the image to the top or place it between the title and the content.', 
          'type' => 'select', 
          'options' => [
            'Top' => 'top', 
            'Between' => 'between'
          ]
        ], 
        'post.image_margin' => [
          'label' => 'Image Margin', 
          'description' => 'Set the top margin if the image is aligned between the title and the content.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ], 
          'enable' => 'post.image_align == \'between\''
        ], 
        'post.image_dimension' => [
          'type' => 'grid', 
          'description' => 'Setting just one value preserves the original proportions. The image will be resized and cropped automatically, and where possible, high resolution images will be auto-generated.', 
          'fields' => [
            'post.image_width' => [
              'label' => 'Image Width', 
              'width' => '1-2', 
              'attrs' => [
                'placeholder' => 'auto', 
                'lazy' => true
              ]
            ], 
            'post.image_height' => [
              'label' => 'Image Height', 
              'width' => '1-2', 
              'attrs' => [
                'placeholder' => 'auto', 
                'lazy' => true
              ]
            ]
          ]
        ], 
        'post.header_align' => [
          'label' => 'Alignment', 
          'description' => 'Align the title and meta text.', 
          'type' => 'checkbox', 
          'text' => 'Center the title and meta text'
        ], 
        'post.title_margin' => [
          'label' => 'Title Margin', 
          'description' => 'Set the top margin.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ]
        ], 
        'post.meta_align' => [
          'label' => 'Meta Alignment', 
          'description' => 'Position the meta text above or below the title.', 
          'type' => 'select', 
          'options' => [
            'Top' => 'top', 
            'Bottom' => 'bottom'
          ]
        ], 
        'post.meta_margin' => [
          'label' => 'Meta Margin', 
          'description' => 'Set the top margin.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ]
        ], 
        'post.meta_style' => [
          'label' => 'Meta Style', 
          'description' => 'Display the meta text in a sentence or a horizontal list.', 
          'type' => 'select', 
          'options' => [
            'List' => 'list', 
            'Sentence' => 'sentence'
          ]
        ], 
        'post.content_margin' => [
          'label' => 'Content Margin', 
          'description' => 'Set the top margin.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ]
        ], 
        'post.content_dropcap' => [
          'label' => 'Drop Cap', 
          'description' => 'Set a large initial letter that drops below the first line of the first paragraph.', 
          'type' => 'checkbox', 
          'text' => 'Show drop cap'
        ], 
        'post.navigation' => [
          'label' => 'Navigation', 
          'description' => 'Enable a navigation to move to the previous or next post.', 
          'type' => 'checkbox', 
          'text' => 'Show navigation'
        ], 
        'post.date' => [
          'label' => 'Display', 
          'type' => 'checkbox', 
          'text' => 'Show date'
        ], 
        'post.author' => [
          'type' => 'checkbox', 
          'text' => 'Show author'
        ], 
        'post.categories' => [
          'type' => 'checkbox', 
          'text' => 'Show categories'
        ], 
        'post.tags' => [
          'description' => 'Show system fields for single posts. This option does not apply to the blog.', 
          'type' => 'checkbox', 
          'text' => 'Show tags'
        ]
      ], 
      'help' => [
        'Post' => [[
            'title' => 'Setting the Post Layout', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=-A7UaUQMy4w&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:50', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#post-layout', 
            'support' => 'support/search?tags=125&q=post'
          ], [
            'title' => 'Setting the Post Image', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=kAaEEVIgjAg&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:54', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#post-image', 
            'support' => 'support/search?tags=125&q=post'
          ], [
            'title' => 'Setting the Post Content', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=hLZP4uQOuio&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:07', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#post-content', 
            'support' => 'support/search?tags=125&q=post'
          ], [
            'title' => 'Setting the Post Navigation', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=1H-cHcK1V7g&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:14', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#post-navigation', 
            'support' => 'support/search?tags=125&q=post'
          ]], 
        'Creating Individual Post Layouts' => [[
            'title' => 'Creating Individual Post Layout', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=Pw42Niyzk7s&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '2:22', 
            'documentation' => 'support/yootheme-pro/wordpress/pages#individual-post-layout', 
            'support' => 'support/search?tags=125&q=builder'
          ]]
      ]
    ], 
    'system-blog' => [
      'title' => 'Blog', 
      'width' => 400, 
      'fields' => [
        'blog.width' => [
          'label' => 'Width', 
          'description' => 'Set the blog width.', 
          'type' => 'select', 
          'options' => [
            'Default' => 'default', 
            'Small' => 'small', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'Expand' => 'expand'
          ]
        ], 
        'blog.padding' => [
          'label' => 'Padding', 
          'description' => 'Set the vertical padding.', 
          'type' => 'select', 
          'options' => [
            'Default' => '', 
            'X-Small' => 'xsmall', 
            'Small' => 'small', 
            'Large' => 'large', 
            'X-Large' => 'xlarge'
          ]
        ], 
        'blog.column' => [
          'label' => 'Columns', 
          'type' => 'select', 
          'options' => [
            1 => 1, 
            2 => 2, 
            3 => 3, 
            4 => 4
          ]
        ], 
        'blog.grid_column_gap' => [
          'label' => 'Column Gap', 
          'description' => 'Set the size of the gap between the grid columns.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Medium' => 'medium', 
            'Default' => '', 
            'Large' => 'large', 
            'None' => 'collapse'
          ], 
          'enable' => 'blog.column != \'1\''
        ], 
        'blog.grid_row_gap' => [
          'label' => 'Row Gap', 
          'description' => 'Set the size of the gap between the grid rows.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Medium' => 'medium', 
            'Default' => '', 
            'Large' => 'large', 
            'None' => 'collapse'
          ]
        ], 
        'blog.grid_breakpoint' => [
          'label' => 'Breakpoint', 
          'description' => 'Set the breakpoint from which grid items will stack.', 
          'type' => 'select', 
          'options' => [
            'Small (Phone Landscape)' => 's', 
            'Medium (Tablet Landscape)' => 'm', 
            'Large (Desktop)' => 'l', 
            'X-Large (Large Screens)' => 'xl'
          ], 
          'enable' => 'blog.column != \'1\''
        ], 
        'blog.grid_masonry' => [
          'label' => 'Masonry', 
          'description' => 'The masonry effect creates a layout free of gaps even if grid items have different heights. ', 
          'type' => 'checkbox', 
          'text' => 'Enable masonry effect', 
          'enable' => 'blog.column != \'1\''
        ], 
        'blog.grid_parallax' => [
          'label' => 'Parallax', 
          'description' => 'The parallax animation moves single grid columns at different speeds while scrolling. Define the vertical parallax offset in pixels.', 
          'type' => 'range', 
          'attrs' => [
            'min' => 0, 
            'max' => 600, 
            'step' => 10
          ], 
          'enable' => 'blog.column != \'1\''
        ], 
        'blog.image_align' => [
          'label' => 'Image Alignment', 
          'description' => 'Align the image to the top or place it between the title and the content.', 
          'type' => 'select', 
          'options' => [
            'Top' => 'top', 
            'Between' => 'between'
          ]
        ], 
        'blog.image_margin' => [
          'label' => 'Image Margin', 
          'description' => 'Set the top margin if the image is aligned between the title and the content.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ], 
          'enable' => 'blog.image_align == \'between\''
        ], 
        'blog.image_dimension' => [
          'type' => 'grid', 
          'description' => 'Setting just one value preserves the original proportions. The image will be resized and cropped automatically, and where possible, high resolution images will be auto-generated.', 
          'fields' => [
            'blog.image_width' => [
              'label' => 'Image Width', 
              'width' => '1-2', 
              'attrs' => [
                'placeholder' => 'auto', 
                'lazy' => true
              ]
            ], 
            'blog.image_height' => [
              'label' => 'Image Height', 
              'width' => '1-2', 
              'attrs' => [
                'placeholder' => 'auto', 
                'lazy' => true
              ]
            ]
          ]
        ], 
        'blog.header_align' => [
          'label' => 'Alignment', 
          'description' => 'Align the title and meta text as well as the continue reading button.', 
          'type' => 'checkbox', 
          'text' => 'Center the title, meta text and button'
        ], 
        'blog.title_style' => [
          'label' => 'Title Style', 
          'description' => 'Title styles differ in font-size but may also come with a predefined color, size and font.', 
          'type' => 'select', 
          'options' => [
            'None' => '', 
            'H1' => 'h1', 
            'H2' => 'h2', 
            'H3' => 'h3', 
            'H4' => 'h4'
          ]
        ], 
        'blog.title_margin' => [
          'label' => 'Title Margin', 
          'description' => 'Set the top margin.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ]
        ], 
        'blog.meta_margin' => [
          'label' => 'Meta Margin', 
          'description' => 'Set the top margin.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ]
        ], 
        'blog.content_excerpt' => [
          'label' => 'Content', 
          'description' => 'Show the excerpt in the blog overview instead of the post text.', 
          'type' => 'checkbox', 
          'text' => 'Use excerpt'
        ], 
        'blog.content_length' => [
          'label' => 'Content Length', 
          'description' => 'Limit the content length to a number of characters. All HTML elements will be stripped.', 
          'type' => 'number', 
          'attrs' => [
            'placeholder' => 'No limit.'
          ]
        ], 
        'blog.content_margin' => [
          'label' => 'Content Margin', 
          'description' => 'Set the top margin.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ]
        ], 
        'blog.content_align' => [
          'label' => 'Content Alignment', 
          'type' => 'checkbox', 
          'text' => 'Center the content'
        ], 
        'blog.button_style' => [
          'label' => 'Button', 
          'description' => 'Select a style for the continue reading button.', 
          'type' => 'select', 
          'options' => [
            'Default' => 'default', 
            'Primary' => 'primary', 
            'Secondary' => 'secondary', 
            'Danger' => 'danger', 
            'Text' => 'text'
          ]
        ], 
        'blog.button_margin' => [
          'label' => 'Button Margin', 
          'description' => 'Set the top margin.', 
          'type' => 'select', 
          'options' => [
            'Small' => 'small', 
            'Default' => 'default', 
            'Medium' => 'medium', 
            'Large' => 'large', 
            'X-Large' => 'xlarge', 
            'None' => 'remove'
          ]
        ], 
        'blog.navigation' => [
          'label' => 'Navigation', 
          'description' => 'Use a numeric pagination or previous/next links to move between blog pages.', 
          'type' => 'select', 
          'options' => [
            'Pagination' => 'pagination', 
            'Previous/Next' => 'previous/next'
          ]
        ], 
        'blog.date' => [
          'label' => 'Display', 
          'type' => 'checkbox', 
          'text' => 'Show date'
        ], 
        'blog.author' => [
          'type' => 'checkbox', 
          'text' => 'Show author'
        ], 
        'blog.categories' => [
          'type' => 'checkbox', 
          'text' => 'Show categories'
        ], 
        'blog.comments' => [
          'type' => 'checkbox', 
          'text' => 'Show comments count'
        ], 
        'blog.content' => [
          'type' => 'checkbox', 
          'text' => 'Show content'
        ], 
        'blog.tags' => [
          'type' => 'checkbox', 
          'text' => 'Show tags'
        ], 
        'blog.button' => [
          'type' => 'checkbox', 
          'text' => 'Show button'
        ], 
        'blog.category_title' => [
          'type' => 'checkbox', 
          'text' => 'Show archive category title', 
          'description' => 'Show system fields for the blog. This option does not apply to single posts.'
        ]
      ], 
      'help' => [
        'Blog' => [[
            'title' => 'Setting the Blog Layout', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=2nbnCKXOvAQ&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:59', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#blog-layout', 
            'support' => 'support/search?tags=125&q=blog'
          ], [
            'title' => 'Setting the Blog Image', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=L_IVcrTf25k&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:54', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#blog-image', 
            'support' => 'support/search?tags=125&q=blog'
          ], [
            'title' => 'Setting the Blog Content', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=zIJrMA6PiUU&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '1:17', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#blog-content', 
            'support' => 'support/search?tags=125&q=blog'
          ], [
            'title' => 'Setting the Blog Navigation', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=Se4Ej2jEiC8&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:16', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#blog-navigation', 
            'support' => 'support/search?tags=125&q=navigation'
          ], [
            'title' => 'Displaying the Excerpt', 
            'src' => 'https://www.youtube-nocookie.com/watch?v=uZCTjGbaPzM&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
            'duration' => '0:48', 
            'documentation' => 'support/yootheme-pro/wordpress/blog-and-post#excerpt', 
            'support' => 'support/search?tags=125&q=excerpt'
          ]]
      ]
    ], 
    'WooCommerce' => [
      'help' => [[
          'title' => 'Setting the WooCommerce Layout Options', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=fxWTGC5NXVM&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '1:19', 
          'documentation' => 'support/yootheme-pro/wordpress/woocommerce#layout-options', 
          'support' => 'support/search?tags=125&q=woocommerce%20layout'
        ], [
          'title' => 'Advanced WooCommerce Integration', 
          'src' => 'https://www.youtube-nocookie.com/watch?v=eljeyhJD1Ms&amp;list=PLrqT0WH0HPdM3qcWFqRRj_SOZ80ze0nKj', 
          'duration' => '0:27', 
          'documentation' => 'support/yootheme-pro/wordpress/woocommerce#advanced-integration', 
          'support' => 'support/search?tags=125&q=woocommerce%20integration'
        ]]
    ]
  ]
];
